/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.entity.ai.goal.glare;

import com.faboslav.friendsandfoes.entity.GlareEntity;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1408;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

public final class GlareFlyToDarkSpotGoal
extends class_1352 {
    public boolean isRunning = false;
    private final double DARK_SPOT_SEARCH_DISTANCE = 8.0;
    private final GlareEntity glare;
    private class_2338 darkSpot;
    private class_11 currentPath;
    private int runTicks;
    private int grumpyTicks;

    public GlareFlyToDarkSpotGoal(GlareEntity glareEntity) {
        this.glare = glareEntity;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
    }

    public boolean method_6264() {
        class_1937 world = this.glare.method_37908();
        if (this.glare.getTicksUntilCanFindDarkSpot() > 0 || this.glare.method_6051().method_43048(10) != 0 || this.glare.method_5934() || this.glare.method_24345() || !this.glare.method_6181() || this.glare.method_6109() || world.method_8530() && world.method_8311(this.glare.method_24515())) {
            return false;
        }
        ArrayList<class_2338> darkSpots = this.findDarkSpots(8.0);
        this.darkSpot = this.getRandomDarkSpot(darkSpots);
        return this.darkSpot != null;
    }

    public boolean method_6266() {
        if (this.runTicks >= 1200 || this.darkSpot == null || this.grumpyTicks >= 120) {
            return false;
        }
        return this.glare.method_37908().method_8314(class_1944.field_9282, this.darkSpot) == 0;
    }

    public void method_6269() {
        this.isRunning = true;
        this.grumpyTicks = 0;
        this.runTicks = 0;
    }

    public void method_6270() {
        this.glare.playGrumpinessShortSound();
        this.darkSpot = null;
        this.currentPath = null;
        this.glare.setTicksUntilCanFindDarkSpot(this.glare.generateRandomTicksUntilCanFindDarkSpot());
        this.glare.setGrumpy(false);
        this.isRunning = false;
    }

    public void method_6268() {
        ++this.runTicks;
        class_1408 navigation = this.glare.method_5942();
        double distanceToDarkSpot = this.glare.method_19538().method_1028((double)this.darkSpot.method_10263(), (double)this.darkSpot.method_10264(), (double)this.darkSpot.method_10260());
        this.currentPath = navigation.method_6352((double)this.darkSpot.method_10263(), (double)this.darkSpot.method_10264(), (double)this.darkSpot.method_10260(), 0);
        if (this.currentPath != null) {
            this.glare.method_5942().method_6334(this.currentPath, (double)this.glare.method_6029());
        }
        if (distanceToDarkSpot >= 1.0) {
            if (this.glare.isGrumpy()) {
                this.glare.setGrumpy(false);
            }
            return;
        }
        class_1309 owner = this.glare.method_6177();
        if (owner == null) {
            return;
        }
        ++this.grumpyTicks;
        if (!this.glare.isGrumpy()) {
            this.glare.setGrumpy(true);
        }
        if (this.grumpyTicks == 10) {
            this.glare.playGrumpinessSound();
        }
        if (this.grumpyTicks % 5 == 0) {
            this.glare.playRustleSound();
        }
        if (this.grumpyTicks % 10 == 0) {
            this.glare.spawnParticles((class_2394)new class_2388(class_2398.field_11217, class_2246.field_28678.method_9564()), 7);
        }
        this.glare.method_5988().method_19615(owner.method_19538());
    }

    private ArrayList<class_2338> findDarkSpots(double searchDistance) {
        class_3218 serverWorld = (class_3218)this.glare.method_5770();
        class_2338 blockPos = this.glare.method_24515();
        ArrayList<class_2338> darkSpots = new ArrayList<class_2338>();
        int i = 0;
        while ((double)i <= searchDistance) {
            int j = 0;
            while ((double)j < searchDistance) {
                int k = 0;
                while (k <= j) {
                    int l;
                    int n = l = k < j && k > -j ? j : 0;
                    while (l <= j) {
                        boolean isBlockAccessible;
                        class_2338.class_2339 possibleDarkSpotBlockPos = new class_2338.class_2339();
                        possibleDarkSpotBlockPos.method_25504((class_2382)blockPos, k, i - 1, l);
                        boolean isBlockWithinDistance = blockPos.method_19771((class_2382)possibleDarkSpotBlockPos, searchDistance);
                        boolean isSpotDarkEnough = this.glare.method_37908().method_8314(class_1944.field_9282, (class_2338)possibleDarkSpotBlockPos) == 0;
                        boolean isBlockSolidSurface = serverWorld.method_8320(possibleDarkSpotBlockPos.method_10074()).method_26168((class_1922)serverWorld, (class_2338)possibleDarkSpotBlockPos, (class_1297)this.glare);
                        boolean bl = isBlockAccessible = serverWorld.method_22347((class_2338)possibleDarkSpotBlockPos) && serverWorld.method_22347(possibleDarkSpotBlockPos.method_10084());
                        if (isBlockWithinDistance && isBlockSolidSurface && isBlockAccessible && isSpotDarkEnough) {
                            darkSpots.add((class_2338)possibleDarkSpotBlockPos);
                        }
                        l = l > 0 ? -l : 1 - l;
                    }
                    k = k > 0 ? -k : 1 - k;
                }
                ++j;
            }
            i = i > 0 ? -i : 1 - i;
        }
        return darkSpots;
    }

    @Nullable
    private class_2338 getRandomDarkSpot(ArrayList<class_2338> darkSpots) {
        int darkSpotsCount = darkSpots.size();
        if (darkSpotsCount == 0) {
            return null;
        }
        int randomDarkSpotIndex = this.glare.method_6051().method_43048(darkSpotsCount);
        return darkSpots.get(randomDarkSpotIndex);
    }
}

